From:	IN%"lenoil@APPLE.COM"  "Robert Lenoil"  9-DEC-1988 21:07
To:	p150bk19@VB.CC.CMU.EDU
Subj:	Disregard prev. msg - PROMPT.E (enclosed) has been found!

Received: from apple.com by VB.CC.CMU.EDU; Fri, 9 Dec 88 21:06 EST
Received: by apple.com (5.59/25-eef) id AA28069; Fri, 9 Dec 88 18:05:21 PST
Date: Fri, 9 Dec 88 18:05:21 PST
From: Robert Lenoil <lenoil@APPLE.COM>
Subject: Disregard prev. msg - PROMPT.E (enclosed) has been found!
To: p150bk19@VB.CC.CMU.EDU
Message-Id: <8812100205.AA28069@apple.com>

/* The following copyright and trademark notice applies to some of the code
 * herein; all other material is Copyright (c) 1986, 1987 by Robert Lenoil,
 * with free copying allowed for any purpose, provided that this copyright
 * notice is included.
 */

/************************************************************************
* "Epsilon", "EEL" and "Lugaru" are trademarks of Lugaru Software, Ltd. *
*                                                                       *
*     Copyright (C) 1985 Lugaru Software Ltd.  All rights reserved.     *
*                                                                       *
* Limited permission is hereby granted to reproduce and modify this     *
* copyrighted material provided that the resulting code is used only in *
* conjunction with Lugaru products and that this notice is retained in  *
* any such reproduction or modification.                                *
************************************************************************/

#include <eel.h>

/* This file adds the following Epsilon commands/procedures:
COMMAND           WRITTEN FOR VERSION
prompt                  3.1

/* PROMPT inputs a prompt, then prompts the user with that prompt, storing
 * the response on the kill ring.  Completion varies depending upon argument
 * to prompt command: 1=filename, 2=command name, 3=buffer name, else normal
 * string input.  Input always comes from keyboard.  Written for 3.1; function
 * was originally present in 2.x.
 */

command prompt()
{  char prompt[80], *thisbuf = bufname;
   int save_ptr = 1, (*func)();
   short *macro_save = (short *) malloc(sizeof(short [MAX_MACRO]));
   jmp_buf new_top_level, *top_level_save = top_level;

   if (setjmp(top_level = &new_top_level))
   {  free((char *) macro_save);
      longjmp(top_level = top_level_save, 1);
   }

   get_string(prompt, "String To Prompt With: ");

   /* We want the following input to come from the keyboard, so we must
    * drain any executing macro of input, saving it away.  Also use
    * wait_for_key instead of getkey so that input is not recorded in any
    * macro definition.
    */
   while (in_macro()) macro_save[save_ptr++] = (wait_for_key(), key);

   /* Input line without recording and save on kill ring. */
   switch (iter)
   {  int get_file(), get_cmd(), get_buf(), get_string();
      case 1: func = get_file; break;
      case 2: func = get_cmd; break;
      case 3: func = get_buf; break;
      default: func = get_string;
   }
   (*func)(prompt, prompt);
   if (len_def_mac)
   {  int input_length = strlen(prompt)+1;
      len_def_mac -= input_length;
      cmd_len -= input_length;
   }
   push_kill();
   bufname = cur_kill_buf;
   stuff(prompt);
   bufname = thisbuf;

   /* execute any remaining macro text */
   if (save_ptr > (iter=1))
   {  macro_save[0] = save_ptr;
      name_macro("prompt-macro", macro_save);
      cmd_len = has_arg = 0;
      prompt_macro();
   }
   free((char *) macro_save);
   top_level = top_level_save;
}
